// sidebar setup
chrome.runtime.onInstalled.addListener(() => {
  chrome.sidePanel.setOptions({ path: 'index.html' });
  chrome.sidePanel.setPanelBehavior({ openPanelOnActionClick: true });
});

function updateBadge(count) {
    if (count > 0) {
        chrome.action.setBadgeText({ text: count.toString() });
        chrome.action.setBadgeBackgroundColor({ color: '#FF0000' });
    } else {
        chrome.action.setBadgeText({ text: '' });
    }
}

function fetchCouponCodeCount(tab) {
    console.log('Fetching coupon code count for tab:', tab);
    const tabUrl = tab.url || null;
    if (!tabUrl) {
        return; // no URL to check
    }
    const rootURL = tabUrl.replace(/^(https?:\/\/)?(www\.)?/, '').split('/')[0];
    // Try to get extension settings from local storage
    chrome.storage.local.get(['settings'], (result) => {
        const settings = result.settings || {};
        const serverUrl = settings?.server_url || null;
        const apiKey = settings?.server_api_key || null;
        if (!serverUrl || !apiKey) {
            return; // extension not configured
        }
        const endpoint = `${serverUrl.replace(/\/+$/, '')}/api/v1/coupon_code_count`;
        console.log(`Fetching coupon code count from ${endpoint} for root URL: ${rootURL}`);
        fetch(endpoint, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Authorization': `Bearer ${apiKey}`
            },
            body: JSON.stringify({ root_domain_name: rootURL })
        }).then(response => response.json()).then(data => {
            const count = data?.count || 0;
            updateBadge(count);
            console.log(`Coupon code count for ${rootURL}: ${count}`);
        }).catch(error => {
            console.error('Error fetching coupon code count:', error);
        });
    });
}

// webNavigation: onCompleted
chrome.webNavigation.onCompleted.addListener((details) => {
    console.log('Web navigation completed:', details);
    chrome.tabs.get(details.tabId, (tab) => fetchCouponCodeCount(tab));
});

// tab activation (this one is easiest because we get windowId directly)
chrome.tabs.onActivated.addListener((activeInfo) => {
    console.log('Tab activated:', activeInfo);
    chrome.tabs.get(activeInfo.tabId, (tab) => fetchCouponCodeCount(tab));
});